function TableData = Table_of_Content(raw_matrix,Classes,xcal,xval,ycal,yval,obj)
% 
%   Table_of_Content function estimates the T2 confidence limits for Hotelling's T^2. 
%   -------------------------------INPUT--------------------------------------
%   m           the number of samples used in the model         
%   ncomp       Number of componets (spectra) to fit.    
%   climit      The confidence limit expressed as a fraction
%           
%   -------------------------------OUTPUT-------------------------------------
%   T2limit        A value of the confidence limit
%
%   See also: pca_svd, qlimit, caltestda
% 
% 	References: 

%
%   This is a part of the GNAT        
%   Copyright  2017  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%   mathias.nilsson@manchester.ac.uk

samples = {};
for i=1:length(Classes)
    a = num2str(i);
    samples{i,1} = ['Sample' '_' a];
end

Cal=[]; Val=[];
Cal(obj.treinamento,:) = 1; Cal(obj.teste,:) = 0;
Val(obj.treinamento,:) = 0; Val(obj.teste,:) = 1;

L = 1:length(Classes);
Log = logical(L)';

TableData = table(samples,Classes,Cal,Val,Log);

assignin('base','TableData',TableData);
% TableData.content(:,1)=NmrData.pca.parameters.Eigenvalue;
% TableData.content(:,2)=NmrData.pca.parameters.var_exp{1,1};
% TableData.content(:,3)=NmrData.pca.parameters.var_cum{1,1};
% TableData.content(:,4)=NmrData.pca.crossvalidation.rmsecv;

end